Defence in Depth is an approach whereby multiple protection mechanisms are layered on top of each other to protect an asset (or assets).  The understanding being that if one mechanism fails, others are in place as backup.  Organisations commonly invest more heavily in their external perimeter and neglect good security practices on their internal network.  This is often under the fallacy that if they keep the attackers out at the perimeter, they don't need to worry about anything else.

The obvious risk is that when (not if) that single external defence fails, attackers get in and are then left relatively unchallenged in reaching their objective.  Such scenarios include client-side attacks like phishing, and pesky network device 0-days such as this [Citrix ADC RCE](https://www.rapid7.com/db/modules/exploit/linux/http/citrix_dir_traversal_rce/).

This is a position that security professionals have been trying to combat for years, but all too often we fail to heed our own advice.  Even though penetration testers and red teamers are there to help an organisation, we can also pose a significant risk to them if we don't do things properly.  Throughout an engagement we are likely to gain access to a lot of sensitive systems and data, and it's ultimately our responsibility to protect that.  I can't think of anything much worse than directly contributing to a client being compromised...

There are several ways in which this could occur, some possibilities include:

-   Leaving unauthenticated backdoors open and accessible via the Internet, such as web shells or SOCKS proxies.
-   Using unencrypted channels, such as netcat or HTTP shells.
-   C2 servers being compromised, e.g. this [Cobalt Strike RCE](https://blog.cobaltstrike.com/2016/09/28/cobalt-strike-rce-active-exploitation-reported/) and [Covenant RCE](https://blog.null.farm/hunting-the-hunters).

This module will cover how to leverage offensive infrastructure that is both secure and resilient.